package game;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;

public class RadioSprite  {
	
	private static CustomImageDataII radioImage = null;
	
	private IntRect collisionRect;
	
	private static final int RADIO_WIDTH = 60;
	private static final int RADIO_HEIGHT = 60;
	
	private Clip audio;
	
	private BackgroundMusic bgm;
	
	private long timestampAllowedForActivation;
	
	private boolean skippingBgmStart = false;
	
	private PonyPanel panel;
	
	private boolean wasActivatedByUser = false;
	
	private String audioName;
	
	private boolean shouldBeFromFiles;
	
	
	private static synchronized void ensureImageIsInitialized(ImageObserver io) {
		if(radioImage == null) {
			
			radioImage = new CustomImageDataII("/images/radio.GIF", Color.white, io);
			
		}
	}
	
	
	public RadioSprite(int xPos, int yPos, String resourceNameOfSoundfile, boolean fromFiles, PonyPanel io) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
		
		audioName = resourceNameOfSoundfile;
		shouldBeFromFiles = fromFiles;
		
		ensureImageIsInitialized(io);
		
		collisionRect = new IntRect(xPos - RADIO_WIDTH/2, yPos - RADIO_HEIGHT/2, RADIO_WIDTH, RADIO_HEIGHT);
		
//		AudioManager am = new AudioManager();
//		if(fromFiles) {
//			audio = am.loadGivenClip(resourceNameOfSoundfile);
//		} else {
//			audio = am.loadGivenClipViaURL(resourceNameOfSoundfile);
//		}
		
		timestampAllowedForActivation = Long.MIN_VALUE;
		panel = io;
		
	}
	
	public IntRect getCollisionRect() {
		return collisionRect;
	}
	
	public void useRadio(BackgroundMusic theBGM, ArrayList<RadioSprite> allRadios) {
		
		if(System.currentTimeMillis() < timestampAllowedForActivation || audio == null)
			return;
		
		if(allRadios != null) {
			for(RadioSprite r : allRadios) {
				if(!this.equals(r))
					r.stopAudioDoNotStartBGM();
			}
		}
		
		
		timestampAllowedForActivation = System.currentTimeMillis() + 500L;
		
//		bgm = theBGM;
//		
//		if(bgm != null) {
//			bgm.pause();
//		}
		
		
		
		if(audio.isRunning()) {
			
			this.wasActivatedByUser = false;
			audio.stop();
//			if(bgm != null)
//				bgm.start();
//			bgm = null;
//			return;
			
			panel.radioCompleted();
			
			
			
			return;
			
		} else {
			
			panel.radioBeginning();
			this.wasActivatedByUser = true;
			
		}
		
		audio.setFramePosition(0);
		audio.start();
		
//		while(!audio.isRunning());
//		
//		Thread listener = new Thread(this);
//		listener.start();
		
	}
	
	public void draw(Graphics g, PlayerSprite player, int panelWidth, int panelHeight) {
		
		Point center = collisionRect.getCenter();
		
//		radioImage.drawObjectFromUpperLeftCorner(g, collisionRect.getMinX(), collisionRect.getMinY());
		if(radioImage != null)
			radioImage.drawObject(g, panelWidth/2 + (center.x - player.getxPos()) , panelHeight/2 + (center.y - player.getyPos()));
		
		if(audio == null) {
			Color col = g.getColor();
			
			g.setColor(Color.cyan);
			g.drawString("loading...", panelWidth/2 + (center.x - player.getxPos()) - 10, panelHeight/2 + (center.y - player.getyPos()));
			
			g.setColor(col);
		}
		
	}
	
	public static RadioSprite readFromFile(BufferedReader in, PonyPanel io, boolean fromFiles) throws Exception {
		
		
		String inputter = null;
		
		String soundFileName = null;
		String xPosStr = null;
		String yPosStr = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("#")) {
				continue;
			} else if(inputter.contains("/radio")) {
				break;
			} else if(inputter.contains("x:")) {
				xPosStr = inputter.substring(2).trim();
			} else if(inputter.contains("y:")) {
				yPosStr = inputter.substring(2).trim();
			} else if(inputter.contains("sound:")) {
				soundFileName = inputter.substring(6).trim();
			}
			
		}
		
		
		
		
		RadioSprite returnValue = new RadioSprite(Integer.parseInt(xPosStr), Integer.parseInt(yPosStr),soundFileName, fromFiles, io);
		
		return returnValue;
		
	}


//	@Override
//	public void run() {
//		System.out.println("now in the waiting method for the RadioSprite; audio.isRunning: " + audio.isRunning());
//		while(bgm != null && audio != null && audio.isRunning()) {
//			//System.out.println("waiting...");
//			Thread.yield();
//		}
//		System.out.println("waiting is done!");
//		if(bgm != null && !skippingBgmStart)
//			bgm.start();
//		
//		skippingBgmStart = false;
//		
//	}
	
	public void checkToSeeIfBgmShouldRestart() {
		
		if(!this.wasActivatedByUser || (audio != null && audio.isRunning()) || audio == null) { //bgm != null && 
			//System.out.println("waiting...");
			return;
		}
//		System.out.println("waiting is done!");
		this.wasActivatedByUser = false;
		if(!skippingBgmStart) { //bgm != null && 
			//bgm.start();
			panel.radioCompleted();
		}
		
		skippingBgmStart = false;
		
	}
	
	public void stopAudio() {
		
		if(this.wasActivatedByUser) {
			panel.radioCompleted();
		}
		
		this.wasActivatedByUser = false;
		
		if(audio != null && audio.isRunning()) {
			
			audio.stop();
//			if(bgm != null)
//				bgm.start();
//			bgm = null;
			return;
		}
		
	}
	
	public void stopAudioDoNotStartBGM() {
		
		this.wasActivatedByUser = false;
		
		if(audio != null && audio.isRunning()) {
			audio.stop();
			skippingBgmStart = true;
			bgm = null;
			return;
		}
		
	}
	
	public boolean equals(Object o) {
		
		if(!(o instanceof RadioSprite))
			return false;
		
		RadioSprite other = (RadioSprite) o;
		
		boolean needToCheckAudio = true;
		
		if(this.audio == null && other.audio == null) {
			needToCheckAudio = false;
		}
		
		if(this.getCollisionRect().getMaxX() != other.getCollisionRect().getMaxX()
				|| this.getCollisionRect().getMinX() != other.getCollisionRect().getMinX()
				|| this.getCollisionRect().getMaxY() != other.getCollisionRect().getMaxY()
				|| this.getCollisionRect().getMinY() != other.getCollisionRect().getMinY()
				|| this.timestampAllowedForActivation != other.timestampAllowedForActivation
				|| (needToCheckAudio ? (
					(this.audio == null && other.audio != null)
					|| (this.audio != null && other.audio == null)
					|| this.audio.getFrameLength() != other.audio.getFrameLength()
					|| this.audio.getFramePosition() != other.audio.getFramePosition()
					) : false))
			return false;
		
		return true;
		
	}
	
	
	

	public static void retrieveFileLengths(BufferedReader in, PonyPanel io, boolean fromFiles, HashMap<String, Long> fileLengths) throws Exception {
		
		
		String inputter = null;
		
		String soundFileName = null;
		String xPosStr = null;
		String yPosStr = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("#")) {
				continue;
			} else if(inputter.contains("/radio")) {
				break;
			} else if(inputter.contains("x:")) {
//				xPosStr = inputter.substring(2).trim();
			} else if(inputter.contains("y:")) {
//				yPosStr = inputter.substring(2).trim();
			} else if(inputter.contains("sound:")) {
				soundFileName = inputter.substring(6).trim();
				
				FileInputStream fis = new FileInputStream(soundFileName);
				
				long lengthOfFile = 0L;
				
				while(fis.read() != -1)
					lengthOfFile++;
				
				fis.close();
				
				fileLengths.put(soundFileName, lengthOfFile);
				
			}
			
		}
		
		
		
		
//		RadioSprite returnValue = new RadioSprite(Integer.parseInt(xPosStr), Integer.parseInt(yPosStr),soundFileName, fromFiles, io);
		
		return ;
		
	}

	
	public boolean isPlaying() {
		if(audio == null)
			return false;
		else
			return audio.isRunning();
	}
	
	
	public void loadUpAudio() {
		
		if(audio == null) {
		
			Thread t = new Thread(new LoadingThread());
			t.start();
		}
	}
	
	
	public synchronized void purgeAudio() {
		
		if(audio != null) {
			audio.close();
			audio = null;
		}
		
	}
	public class LoadingThread implements Runnable {

		@Override
		public void run() {
			
//			System.out.println("<><>DELME loading up " + audioName + " now...");
			
			AudioManager am = new AudioManager();
			if(shouldBeFromFiles) {
				try {
					audio = am.loadGivenClip(audioName);
				} catch(Exception e) {
					String message = PonyPanel.formatStackTrace(e);
					
					message = message.replace("\n", "<br>");
					JOptionPane.showMessageDialog(null, "<html>An error occurred while loading an audio clip:<br><br>"+message+"</html>","Error",JOptionPane.ERROR_MESSAGE);
					
					System.exit(1);
				}
			} else {
				audio = am.loadGivenClipViaURL(audioName);
			}
			
		}
		
		
		
	}
	
}
